#include <bits/stdc++.h>

using namespace std;

typedef vector<int> vi;
typedef vector<vi> vvi;
typedef pair<int, int> pii;
typedef map<pii, bool> mpb;
typedef map<int, bool> mib;

#define MP make_pair
#define PB push_back
#define S second

vvi grid;
mpb visited;

int N, K;

void input(){
    scanf("%d %d", &N, &K);
    for(int i = 0; i < N; i++){
        vi row;
        for(int j = 0; j < N; j++){
            int cur;
            scanf("%d", &cur);
            row.PB(cur);
            visited[MP(i, j)] = false;
        }
        grid.PB(row);
    }
}

void output(mib searched){
    int res = 0;
    for(auto const& it : searched){
        if(it.S){
            res++;
        }
    }
    printf("%d", res);
}


int next_in_row(int row, int col, int x){
    int out = 0;
    for(int i = col + 1; i < N; i++){
        if(grid[row][i] == x){
            out++;
            visited[MP(row, i)] = true;
        } else {
            break;
        }
    }
    return out;
}

bool next_in_col(int row, int col, int x, int m){
    for(int i = row + 1; i < N; i++){
        if(grid[i][col] != x){
            break;
        }
        visited[MP(i, col)] = true;
        int found = next_in_row(i, col, x);
        if(found != m){
            // Impossible to make rectangle with x
            return false;
        }
    }
    return true;
}

void Solve(){
    mib searched_K;

    for(int i = 0; i < N; i++){
        if(searched_K.size() == K){
            break;
        }
        for(int j = 0; j < N; j++){
            int cur_x = grid[i][j];
            if(searched_K.count(cur_x) == 0){
                searched_K[cur_x] = false;
                int m = next_in_row(i, j, cur_x);

                if(next_in_col(i, j, cur_x, m)){
                    searched_K[cur_x] = true;
                }
            } else if(visited[MP(i, j)] == false) {
                searched_K[cur_x] = false;
            }
        }
    }

    output(searched_K);
}


int main()
{
    input();
    Solve();
    return 0;
}